/*
 * Decompiled with CFR 0.152.
 */
package jtides;

import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public final class MyJButton
extends JButton {
    Border activeBorder;
    Border passiveBorder;

    public MyJButton() {
        this.myInit();
    }

    public MyJButton(Icon icon) {
        super(icon);
        this.myInit();
    }

    public MyJButton(String string) {
        super(string);
        this.myInit();
    }

    public MyJButton(String string, Icon icon) {
        super(string, icon);
        this.myInit();
    }

    private void myInit() {
        this.activeBorder = new BevelBorder(0);
        this.passiveBorder = this.getBorder();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                MyJButton.this.formMouseEntered(mouseEvent);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                MyJButton.this.formMouseExited(mouseEvent);
            }
        });
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!bl) {
            this.setDefaultBorder();
        }
    }

    private Insets getDiffInsets(Insets insets) {
        Insets insets2 = this.getInsets();
        return new Insets(insets2.top - insets.top, insets2.left - insets.left, insets2.bottom - insets.bottom, insets2.right - insets.right);
    }

    private void formMouseEntered(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            Insets insets = this.getDiffInsets(this.activeBorder.getBorderInsets(this));
            super.setBorder(new CompoundBorder(this.activeBorder, new EmptyBorder(insets)));
        }
    }

    private void formMouseExited(MouseEvent mouseEvent) {
        this.setDefaultBorder();
    }

    private void setDefaultBorder() {
        Insets insets = this.getDiffInsets(this.passiveBorder.getBorderInsets(this));
        super.setBorder(new CompoundBorder(this.passiveBorder, new EmptyBorder(insets)));
    }
}

